from django.conf import settings
from django.contrib import messages
from django.shortcuts import render, redirect
from django.contrib.auth.decorators import login_required
from .models import Withdrawal
from django.utils import timezone

@login_required
def withdraw_view(request):
    if request.method == "POST":
        amount = float(request.POST.get('amount'))

        if amount < settings.MIN_WITHDRAWAL_AMOUNT:
            messages.error(
                request,
                f"Minimum withdrawal amount is {settings.MIN_WITHDRAWAL_AMOUNT}"
            )
            return redirect('withdraw')

        if request.user.balance < amount:
            messages.error(request, "Insufficient balance")
            return redirect('withdraw')

        user = request.user

        user.balance -= int(amount)
        user.save()
        
        tax_amount = int(amount) * 20 / 100
        
        final_amount = int(amount) - tax_amount

        Withdrawal.objects.create(user=request.user, amount=final_amount)
        messages.success(request, "Withdrawal request submitted")
        return redirect('profile')

    return render(request, 'dashboard/withdraw.html', {'min': settings.MIN_WITHDRAWAL_AMOUNT})

