from django.contrib import admin
from .models import Withdrawal

@admin.register(Withdrawal)
class WithdrawalAdmin(admin.ModelAdmin):
    list_display = (
        'user',
        'amount',
        'status',
        'created_at',
    )
    list_filter = ('status',)
    actions = ['approve_withdrawals', 'reject_withdrawals']

    def approve_withdrawals(self, request, queryset):
        for w in queryset.filter(status='PENDING'):
            if w.user.balance >= w.amount:
                w.user.balance -= w.amount
                w.user.save()
                w.status = 'APPROVED'
                w.save()

    def reject_withdrawals(self, request, queryset):
        queryset.filter(status='PENDING').update(status='REJECTED')

    approve_withdrawals.short_description = "Approve selected withdrawals"
    reject_withdrawals.short_description = "Reject selected withdrawals"

