from django.contrib.auth.decorators import login_required
from django.shortcuts import render, redirect
from .models import Transaction
from recharges.models import Recharge
from withdrawals.models import Withdrawal
from django.core.exceptions import ValidationError
from django.contrib import messages

@login_required
def profile_view(request):
    transactions = Transaction.objects.filter(user=request.user).order_by('-created_at')
    return render(request, 'dashboard/profile.html', {
        'transactions': transactions
    })
    
@login_required
def recharge_view(request):
    if request.method == 'POST':
        amount = request.POST.get('amount')
        trans_id = request.POST.get('trans_id')

        if int(amount) < 50:
            messages.error(
                request,
                "Minimum deposit is GHS 50.00"
            )
        else:
            try:
                Recharge.objects.create(
                user=request.user,
                amount=amount,
                trans_id=trans_id, 
                status='PENDING'
            )
                messages.success(
                    request,
                    "Recharge sent successfully"
                )
            except ValidationError as e:
                messages.error(
                    request,
                    "Field is empty"
                )

    return render(request, 'dashboard/recharge.html')
    
@login_required
def withdraw_view(request):
    if request.method == 'POST':
        amount = float(request.POST.get('amount'))

        if request.user.balance < amount:
            return redirect('profile')

        request.user.balance -= int(amount)
        request.user.save()

        try:
            Withdrawal.objects.create(
            user=request.user,
            amount=amount,
            status='PENDING'
        )
        except ValidationError as e:
            messages.error(
                request,
                "Field is empty"
            )

    return render(request, 'dashboard/withdraw.html')

