from django.db import models
from mains.models import User

# wallet/models.py
class Transaction(models.Model):
    TRANSACTION_TYPES = (
        ('recharge', 'Recharge'),
        ('withdraw', 'Withdraw'),
        ('income', 'Daily Income'),
    )

    user = models.ForeignKey(User, on_delete=models.CASCADE)
    tx_type = models.CharField(max_length=10, choices=TRANSACTION_TYPES)
    amount = models.DecimalField(max_digits=10, decimal_places=2)
    status = models.CharField(
        max_length=10,
        choices=(('pending','pending'),('approved','approved'))
    )
    created_at = models.DateTimeField(auto_now_add=True)

