from django.contrib import admin
from .models import Transaction

@admin.register(Transaction)
class TransactionAdmin(admin.ModelAdmin):
    list_display = (
        'user',
        'tx_type',
        'amount',
        'status',
        'created_at'
    )
    list_filter = ('tx_type', 'status')
    search_fields = ('user__phone',)
    actions = ['approve_withdrawals']
    
@admin.action(description="Approve selected withdrawals")
def approve_withdrawals(modeladmin, request, queryset):
    for tx in queryset.filter(tx_type='withdraw', status='pending'):
        tx.status = 'approved'
        tx.save()

