from django.contrib.auth.decorators import login_required
from django.shortcuts import render
from recharges.models import Recharge
from withdrawals.models import Withdrawal
from imvestments.models import Investment

@login_required
def transaction_history(request):
    recharges = Recharge.objects.filter(user=request.user)
    withdrawals = Withdrawal.objects.filter(user=request.user)
    investments = Investment.objects.filter(user=request.user)

    transactions = []

    for r in recharges:
        transactions.append({
            'type': 'Recharge',
            'amount': r.amount,
            'status': r.status,
            'date': r.created_at,
        })

    for w in withdrawals:
        transactions.append({
            'type': 'Withdrawal',
            'amount': w.amount,
            'status': w.status,
            'date': w.created_at,
        })

    for i in investments:
        transactions.append({
            'type': 'Investment',
            'amount': i.amount,
            'status': i.is_active,
            'date': i.start_date,
        })

    transactions.sort(key=lambda x: x['date'], reverse=True)

    return render(
        request,
        'dashboard/transactions.html',
        {'transactions': transactions}
    )
    
