from django.contrib.auth.decorators import login_required
from django.shortcuts import render
from mains.models import User

@login_required
def share_view(request):
    referrals = User.objects.filter(referred_by=request.user)

    referral_link = request.build_absolute_uri(
        f"/register/?inviteCode={request.user.referral_code}"
    )

    return render(request, 'dashboard/share.html', {
        'referrals': referrals,
        'referral_link': referral_link
    })

