from django.contrib import admin
from .models import Recharge

@admin.register(Recharge)
class RechargeAdmin(admin.ModelAdmin):
    list_display = ('user', 'amount', 'trans_id', 'status', 'created_at')
    list_filter = ('status',)
    fields = ['user', 'amount', 'trans_id', 'status']
    actions = ['approve_recharges', 'reject_recharges']

    def approve_recharges(self, request, queryset):
        for r in queryset.filter(status='PENDING'):
            r.user.balance += r.amount
            r.user.save()
            r.status = 'APPROVED'
            r.save()

    def reject_recharges(self, request, queryset):
        queryset.filter(status='PENDING').update(status='REJECTED')

