from django.contrib.auth.decorators import login_required
from django.shortcuts import render, redirect
from .models import BankAccount

@login_required
def bank_account_view(request):
    account, created = BankAccount.objects.get_or_create(
        user=request.user
    )

    if request.method == "POST":
        account.account_number = request.POST.get('account_number')
        account.network = request.POST.get('network')
        account.account_name = request.POST.get('account_name')
        account.save()
        return redirect('profile')

    return render(request, 'dashboard/bank_account.html', {
        'account': account
    })

