from django.db import models
from django.conf import settings

User = settings.AUTH_USER_MODEL

class BankAccount(models.Model):
    NETWORK_CHOICES = (
        ('MTN', 'MTN'),
        ('TELECEL', 'Telecel'),
        ('AIRTELTIGO', 'Airtel Tigo'),
    )

    user = models.OneToOneField(User, on_delete=models.CASCADE)
    account_number = models.CharField(max_length=20)
    network = models.CharField(max_length=20, choices=NETWORK_CHOICES)
    account_name = models.CharField(max_length=100)

    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return f"{self.user} - {self.network}"
        
