from django.contrib import admin
from .models import BankAccount

@admin.register(BankAccount)
class BankAccountAdmin(admin.ModelAdmin):
    list_display = (
        'user',
        'network',
        'account_number',
        'account_name',
        'updated_at',
    )
    search_fields = ('account_number', 'user__phone')
    
