from django.shortcuts import render, redirect
from django.contrib.auth import authenticate, login, logout
from django.contrib import messages
from .models import User
import uuid

def login_view(request):
    if request.method == 'POST':
        phone = request.POST.get('phone')
        password = request.POST.get('password')

        user = authenticate(request, phone=phone, password=password)
        if user is not None:
            login(request, user)
            return redirect('home')
        else:
            messages.error(request, 'Invalid login details')

    return render(request, 'registration/login.html')
    

def register_view(request):
    ref_code = request.GET.get('inviteCode')

    if request.method == 'POST':
        phone = request.POST.get('phone')
        password = request.POST.get('password')

        referred_by = None
        if ref_code:
            referred_by = User.objects.filter(referral_code=ref_code).first()

        user = User.objects.create_user(
            phone=phone,
            password=password,
            referral_code=str(uuid.uuid4())[:8],
            referred_by=referred_by
        )

        login(request, user)
        return redirect('home')

    return render(request, 'registration/register.html', {'ref_code': ref_code})
    
def logout_view(request):
    logout(request)
    return redirect('login')

