from django.contrib import admin
from .models import User
from imvestments.utils import run_daily_profit_once

#auto add profits to eligible user's balance
#run_daily_profit_once()

@admin.register(User)
class UserAdmin(admin.ModelAdmin):
    list_display = (
        'phone',
        'balance',
        'referral_code',
        'referred_by',
        'is_active',
        'is_staff',
    )
    search_fields = ('phone', 'referral_code')
    list_filter = ('is_active', 'is_staff')
    ordering = ('-id',)

    fieldsets = (
        ('Basic Info', {
            'fields': ('phone', 'password')
        }),
        ('Financial', {
            'fields': ('balance',)
        }),
        ('Referral', {
            'fields': ('referral_code', 'referred_by')
        }),
        ('Permissions', {
            'fields': ('is_active', 'is_staff', 'is_superuser')
        }),
    )

