from django.contrib.auth.decorators import login_required
from django.shortcuts import redirect, render, get_object_or_404
from django.contrib import messages
from products.models import Product
from .models import Investment, ProfitRecord

@login_required
def invest_now(request, product_id):
    product = get_object_or_404(Product, id=product_id)
    user = request.user

    if user.balance < product.price:
        messages.error(request, "Insufficient balance")
        return redirect('home')

    # Deduct balance
    user.balance -= product.price
    user.save()

    # Create investment
    Investment.objects.create(
        user=user,
        product=product,
        amount=product.price
    )

    messages.success(request, "Investment successful")
    return redirect('my-investments')

@login_required
def home_view(request):
    products = Product.objects.all()
    
    show_popup = False
    
    if request.user.is_authenticated:
        show_popup = True
    
    return render(request, 'dashboard/home.html', {'products': products, "show_popup": show_popup})
    
@login_required
def my_investments(request):
    investments = Investment.objects.filter(user=request.user)
    return render(request, 'dashboard/my_products.html', {
        'investments': investments
    })

@login_required
def profit_history(request):
    profits = ProfitRecord.objects.filter(user=request.user).order_by('-created_at')
    return render(request, 'dashboard/profit_history.html', {'profits': profits})

def credit_daily_income():
    plans = UserPlan.objects.filter(active=True, days_remaining__gt=0)

    for up in plans:
        up.user.balance += up.plan.daily_income
        up.total_earned += up.plan.daily_income
        up.days_remaining -= 1

        if up.days_remaining == 0:
            up.active = False

        up.user.save()
        up.save()
        
def referral_bonus(user, amount):
    if user.referred_by:
        bonus = amount * 0.05
        user.referred_by.balance += bonus
        user.referred_by.save()
    
