from django.utils import timezone
from django.core.cache import cache
from .services import calculate_daily_profits

def run_daily_profit_once():
    today = timezone.now().date().isoformat()

    if cache.get('profit_run_date') == today:
        return

    calculate_daily_profits()
    cache.set('profit_run_date', today, 86400)

