from django.utils import timezone
from .models import Investment, ProfitRecord

def calculate_daily_profits():
    today = timezone.now().date()
    investments = Investment.objects.filter(is_active=True)

    for inv in investments:
        if inv.days_running() >= inv.product.duration_days:
            inv.is_active = False
            inv.save()
            continue

        if inv.last_profit_date == today:
            continue

        # Add profit to balance
        inv.user.balance += inv.product.daily_profit
        inv.user.save()

        # Create profit record
        ProfitRecord.objects.create(
            user=inv.user,
            investment=inv,
            amount=inv.product.daily_profit
        )

        inv.last_profit_date = today
        inv.save()
        
        