from django.db import models
from django.conf import settings
from django.utils import timezone
from products.models import Product

User = settings.AUTH_USER_MODEL

class Investment(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    product = models.ForeignKey(Product, on_delete=models.CASCADE)
    amount = models.DecimalField(max_digits=10, decimal_places=2)
    start_date = models.DateTimeField(auto_now_add=True)
    is_active = models.BooleanField(default=True)
    last_profit_date = models.DateTimeField(null=True, blank=True)

    def days_running(self):
        return (timezone.now().date() - self.start_date.date()).days

    def __str__(self):
        return f"{self.user} - {self.product}"

class ProfitRecord(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    investment = models.ForeignKey(Investment, on_delete=models.CASCADE)
    amount = models.DecimalField(max_digits=10, decimal_places=2)
    created_at = models.DateTimeField(auto_now_add=True)

    def __str__(self):
        return f"{self.user} - {self.amount}"

