from django.contrib import admin
from .models import Investment
from .services import calculate_daily_profits

@admin.register(Investment)
class InvestmentAdmin(admin.ModelAdmin):
    list_display = ('user', 'product', 'amount', 'is_active', 'start_date')
    list_filter = ('is_active', 'product')
    search_fields = ('user__phone',)
    actions = ['run_daily_profit']

    def run_daily_profit(self, request, queryset):
        calculate_daily_profits()
        self.message_user(request, "Daily profits calculated successfully")

    run_daily_profit.short_description = "Run daily profit calculation"

